<?php
/**
 * The template 'Style 2' to displaying related posts
 *
 * @package YOKOO
 * @since YOKOO 1.0
 */

$yokoo_link        = get_permalink();
$yokoo_post_format = get_post_format();
$yokoo_post_format = empty( $yokoo_post_format ) ? 'standard' : str_replace( 'post-format-', '', $yokoo_post_format );
?><div id="post-<?php the_ID(); ?>" <?php post_class( 'related_item post_format_' . esc_attr( $yokoo_post_format ) ); ?> data-post-id="<?php the_ID(); ?>">
	<?php
	yokoo_show_post_featured(
		array(
			'thumb_size'    => apply_filters( 'yokoo_filter_related_thumb_size', yokoo_get_thumb_size( (int) yokoo_get_theme_option( 'related_posts' ) == 1 ? 'huge' : 'extra' ) ),
			'thumb_ratio'   => '760:590',
		)
	);
	?>

	<?php
	if ( in_array( get_post_type(), array( 'post', 'attachment' ) ) ) {
		?>
		<div class="post_meta_top">
			<a href="<?php echo esc_url( $yokoo_link ); ?>" class="post_meta_item post_date"><?php echo wp_kses_data( yokoo_get_date() ); ?></a>
		</div>
		<?php
	}
	?>

	<div class="post_header entry-header">
		<h6 class="post_title entry-title"><a href="<?php echo esc_url( $yokoo_link ); ?>"><?php
			if ( '' == get_the_title() ) {
				esc_html_e( '- No title -', 'yokoo' );
			} else {
				the_title();
			}
		?></a></h6>
		<?php
		if ( in_array( get_post_type(), array( 'post', 'attachment' ) ) ) {
			yokoo_show_post_meta(
					array(
					'components' => 'likes,comments',
					'seo'        => false,
					'echo'       => true,
				)
			);
		}
		?>
		<a class="sc_button sc_button_simple" href="<?php echo esc_url( $yokoo_link ); ?>"><?php esc_html_e('Read more', 'yokoo'); ?></a>
	</div>
</div>
