<?php
/**
 * The template to display the widgets area in the header
 *
 * @package YOKOO
 * @since YOKOO 1.0
 */

// Header sidebar
$yokoo_header_name    = yokoo_get_theme_option( 'header_widgets' );
$yokoo_header_present = ! yokoo_is_off( $yokoo_header_name ) && is_active_sidebar( $yokoo_header_name );
if ( $yokoo_header_present ) {
	yokoo_storage_set( 'current_sidebar', 'header' );
	$yokoo_header_wide = yokoo_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $yokoo_header_name ) ) {
		dynamic_sidebar( $yokoo_header_name );
	}
	$yokoo_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $yokoo_widgets_output ) ) {
		$yokoo_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $yokoo_widgets_output );
		$yokoo_need_columns   = strpos( $yokoo_widgets_output, 'columns_wrap' ) === false;
		if ( $yokoo_need_columns ) {
			$yokoo_columns = max( 0, (int) yokoo_get_theme_option( 'header_columns' ) );
			if ( 0 == $yokoo_columns ) {
				$yokoo_columns = min( 6, max( 1, yokoo_tags_count( $yokoo_widgets_output, 'aside' ) ) );
			}
			if ( $yokoo_columns > 1 ) {
				$yokoo_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $yokoo_columns ) . ' widget', $yokoo_widgets_output );
			} else {
				$yokoo_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $yokoo_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'yokoo_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $yokoo_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $yokoo_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'yokoo_action_before_sidebar', 'header' );
				yokoo_show_layout( $yokoo_widgets_output );
				do_action( 'yokoo_action_after_sidebar', 'header' );
				if ( $yokoo_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $yokoo_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'yokoo_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
