<?php
/**
 * The template to show mobile menu (used only header_style == 'default')
 *
 * @package YOKOO
 * @since YOKOO 1.0
 */
?>
<div class="menu_mobile_overlay"></div>
<div class="menu_mobile menu_mobile_<?php echo esc_attr( yokoo_get_theme_option( 'menu_mobile_fullscreen' ) > 0 ? 'fullscreen' : 'narrow' ); ?> scheme_dark">
	<div class="menu_mobile_inner">
		<a class="menu_mobile_close theme_button_close" tabindex="0"><span class="theme_button_close_icon"></span></a>
		<?php

		// Logo
		set_query_var( 'yokoo_logo_args', array( 'type' => 'mobile' ) );
		get_template_part( apply_filters( 'yokoo_filter_get_template_part', 'templates/header-logo' ) );
		set_query_var( 'yokoo_logo_args', array() );

		// Mobile menu
		$yokoo_menu_mobile = yokoo_get_nav_menu( 'menu_mobile' );
		if ( empty( $yokoo_menu_mobile ) ) {
			$yokoo_menu_mobile = apply_filters( 'yokoo_filter_get_mobile_menu', '' );
			if ( empty( $yokoo_menu_mobile ) ) {
				$yokoo_menu_mobile = yokoo_get_nav_menu( 'menu_main' );
				if ( empty( $yokoo_menu_mobile ) ) {
					$yokoo_menu_mobile = yokoo_get_nav_menu();
				}
			}
		}
		if ( ! empty( $yokoo_menu_mobile ) ) {
			$yokoo_menu_mobile = str_replace(
				array( 'menu_main',   'id="menu-',        'sc_layouts_menu_nav', 'sc_layouts_menu ', 'sc_layouts_hide_on_mobile', 'hide_on_mobile' ),
				array( 'menu_mobile', 'id="menu_mobile-', '',                    ' ',                '',                          '' ),
				$yokoo_menu_mobile
			);
			if ( strpos( $yokoo_menu_mobile, '<nav ' ) === false ) {
				$yokoo_menu_mobile = sprintf( '<nav class="menu_mobile_nav_area" itemscope="itemscope" itemtype="%1$s//schema.org/SiteNavigationElement">%2$s</nav>', esc_attr( yokoo_get_protocol( true ) ), $yokoo_menu_mobile );
			}
			yokoo_show_layout( apply_filters( 'yokoo_filter_menu_mobile_layout', $yokoo_menu_mobile ) );
		}

		// Search field
		do_action(
			'yokoo_action_search',
			array(
				'style' => 'normal',
				'class' => 'search_mobile',
				'ajax'  => false
			)
		);

		// Social icons
		yokoo_show_layout( yokoo_get_socials_links(), '<div class="socials_mobile">', '</div>' );
		?>
	</div>
</div>
