<?php
/**
 * The template to display the site logo in the footer
 *
 * @package YOKOO
 * @since YOKOO 1.0.10
 */

// Logo
if ( yokoo_is_on( yokoo_get_theme_option( 'logo_in_footer' ) ) ) {
	$yokoo_logo_image = yokoo_get_logo_image( 'footer' );
	$yokoo_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $yokoo_logo_image['logo'] ) || ! empty( $yokoo_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $yokoo_logo_image['logo'] ) ) {
					$yokoo_attr = yokoo_getimagesize( $yokoo_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $yokoo_logo_image['logo'] ) . '"'
								. ( ! empty( $yokoo_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $yokoo_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'yokoo' ) . '"'
								. ( ! empty( $yokoo_attr[3] ) ? ' ' . wp_kses_data( $yokoo_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $yokoo_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $yokoo_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
