<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package YOKOO
 * @since YOKOO 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$yokoo_copyright_scheme = yokoo_get_theme_option( 'copyright_scheme' );
if ( ! empty( $yokoo_copyright_scheme ) && ! yokoo_is_inherit( $yokoo_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $yokoo_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$yokoo_copyright = yokoo_get_theme_option( 'copyright' );
			if ( ! empty( $yokoo_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$yokoo_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $yokoo_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$yokoo_copyright = yokoo_prepare_macros( $yokoo_copyright );
				// Display copyright
				echo wp_kses( nl2br( $yokoo_copyright ), 'yokoo_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
