<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package YOKOO
 * @since YOKOO 1.0
 */

$yokoo_template_args = get_query_var( 'yokoo_template_args' );
if ( is_array( $yokoo_template_args ) ) {
	$yokoo_columns    = empty( $yokoo_template_args['columns'] ) ? 2 : max( 1, $yokoo_template_args['columns'] );
	$yokoo_blog_style = array( $yokoo_template_args['type'], $yokoo_columns );
} else {
	$yokoo_blog_style = explode( '_', yokoo_get_theme_option( 'blog_style' ) );
	$yokoo_columns    = empty( $yokoo_blog_style[1] ) ? 2 : max( 1, $yokoo_blog_style[1] );
}

$yokoo_post_format = get_post_format();
$yokoo_post_format = empty( $yokoo_post_format ) ? 'standard' : str_replace( 'post-format-', '', $yokoo_post_format );

?><div class="
<?php
if ( ! empty( $yokoo_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( yokoo_is_blog_style_use_masonry( $yokoo_blog_style[0] ) ? 'masonry_item masonry_item' : 'column' ) . '-1_' . esc_attr( $yokoo_columns );
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $yokoo_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $yokoo_columns )
		. ( 'portfolio' != $yokoo_blog_style[0] ? ' ' . esc_attr( $yokoo_blog_style[0] )  . '_' . esc_attr( $yokoo_columns ) : '' )
		. ( is_sticky() && ! is_paged() ? ' sticky' : '' )
	);
	yokoo_add_blog_animation( $yokoo_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$yokoo_hover   = ! empty( $yokoo_template_args['hover'] ) && ! yokoo_is_inherit( $yokoo_template_args['hover'] )
								? $yokoo_template_args['hover']
								: yokoo_get_theme_option( 'image_hover' );

	if ( 'dots' == $yokoo_hover ) {
		$yokoo_post_link = empty( $yokoo_template_args['no_links'] )
								? ( ! empty( $yokoo_template_args['link'] )
									? $yokoo_template_args['link']
									: get_permalink()
									)
								: '';
		$yokoo_target    = ! empty( $yokoo_post_link ) && false === strpos( $yokoo_post_link, home_url() )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$yokoo_components = ! empty( $yokoo_template_args['meta_parts'] )
							? ( is_array( $yokoo_template_args['meta_parts'] )
								? $yokoo_template_args['meta_parts']
								: explode( ',', $yokoo_template_args['meta_parts'] )
								)
							: yokoo_array_get_keys_by_value( yokoo_get_theme_option( 'meta_parts' ) );

	// Featured image
	yokoo_show_post_featured(
		array(
			'hover'         => $yokoo_hover,
			'no_links'      => ! empty( $yokoo_template_args['no_links'] ),
			'thumb_size'    => yokoo_get_thumb_size(
									yokoo_is_blog_style_use_masonry( $yokoo_blog_style[0] )
										? (	strpos( yokoo_get_theme_option( 'body_style' ), 'full' ) !== false || $yokoo_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( yokoo_get_theme_option( 'body_style' ), 'full' ) !== false || $yokoo_columns < 3
											? 'big'
											: 'med'
											)
								),
			'show_no_image' => true,
			'meta_parts'    => $yokoo_components,
			'class'         => 'dots' == $yokoo_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $yokoo_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $yokoo_post_link )
												? '<a href="' . esc_url( $yokoo_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $yokoo_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
		)
	);
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!