<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package YOKOO
 * @since YOKOO 1.0
 */

$yokoo_template_args = get_query_var( 'yokoo_template_args' );
$yokoo_columns = 1;
if ( is_array( $yokoo_template_args ) ) {
	$yokoo_columns    = empty( $yokoo_template_args['columns'] ) ? 1 : max( 1, $yokoo_template_args['columns'] );
	$yokoo_blog_style = array( $yokoo_template_args['type'], $yokoo_columns );
	if ( ! empty( $yokoo_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $yokoo_columns > 1 ) {
		?>
		<div class="column-1_<?php echo esc_attr( $yokoo_columns ); ?>">
		<?php
	}
}
$yokoo_expanded    = ! yokoo_sidebar_present() && yokoo_get_theme_option( 'expand_content' ) == 'expand';
$yokoo_post_format = get_post_format();
$yokoo_post_format = empty( $yokoo_post_format ) ? 'standard' : str_replace( 'post-format-', '', $yokoo_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $yokoo_post_format ) );
	yokoo_add_blog_animation( $yokoo_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$yokoo_hover      = ! empty( $yokoo_template_args['hover'] ) && ! yokoo_is_inherit( $yokoo_template_args['hover'] )
							? $yokoo_template_args['hover']
							: yokoo_get_theme_option( 'image_hover' );
	$yokoo_components = ! empty( $yokoo_template_args['meta_parts'] )
							? ( is_array( $yokoo_template_args['meta_parts'] )
								? $yokoo_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $yokoo_template_args['meta_parts'] ) )
								)
							: yokoo_array_get_keys_by_value( yokoo_get_theme_option( 'meta_parts' ) );



			// Date
			$yokoo_components_date = '';
			$has_thumb = has_post_thumbnail();
			if ( $has_thumb && count( $yokoo_components ) > 0 && in_array( 'date', $yokoo_components ) && ! in_array( $yokoo_post_format, array( 'audio' ) )) {
				$yokoo_components_date = yokoo_show_post_meta( apply_filters(
												'yokoo_filter_post_meta_args',
												array(
													'components' => 'date',
													'seo'        => false,
													'echo'       => false,
													),
												'hover_' . $yokoo_hover, 1
												)
								);
				$yokoo_components = yokoo_array_delete_by_value( $yokoo_components, 'date' );
			}



	yokoo_show_post_featured(
		array(
			'no_links'   => ! empty( $yokoo_template_args['no_links'] ),
			'hover'      => $yokoo_hover,
			'post_info'  => $yokoo_components_date,
			'meta_parts' => $yokoo_components,
			'thumb_size' => yokoo_get_thumb_size( strpos( yokoo_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $yokoo_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		)
	);

	// Title and post meta
	$yokoo_show_title = get_the_title() != '';
	$yokoo_show_meta  = count( $yokoo_components ) > 0 && ! in_array( $yokoo_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( true ) {
		?>
		<div class="post_header entry-header">
			<?php
			if ( $yokoo_show_title ) {
				// Post title
				if ( apply_filters( 'yokoo_filter_show_blog_title', true, 'excerpt' ) ) {
					do_action( 'yokoo_action_before_post_title' );
					if ( empty( $yokoo_template_args['no_links'] ) ) {
						the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
					} else {
						the_title( '<h3 class="post_title entry-title">', '</h3>' );
					}
					do_action( 'yokoo_action_after_post_title' );
				}
			}
			// Post meta
			if ( apply_filters( 'yokoo_filter_show_blog_meta', $yokoo_show_meta, $yokoo_components, 'excerpt' ) ) {
				if ( count( $yokoo_components ) > 0 ) {
					do_action( 'yokoo_action_before_post_meta' );
					yokoo_show_post_meta(
						apply_filters(
							'yokoo_filter_post_meta_args', array(
								'components' => join( ',', $yokoo_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'yokoo_action_after_post_meta' );
				}
			}

			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'yokoo_filter_show_blog_excerpt', empty( $yokoo_template_args['hide_excerpt'] ) && yokoo_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php
			if ( yokoo_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'yokoo_action_before_full_post_content' );
					the_content( '' );
					do_action( 'yokoo_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'yokoo' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'yokoo' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				yokoo_show_post_content( $yokoo_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'yokoo_filter_show_blog_readmore', true, 'excerpt' ) ) {
				if ( empty( $yokoo_template_args['no_links'] ) ) {
					do_action( 'yokoo_action_before_post_readmore' );
					if ( yokoo_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						yokoo_show_post_more_link( $yokoo_template_args, '<p>', '</p>' );
					} else {
						yokoo_show_post_comments_link( $yokoo_template_args, '<p>', '</p>' );
					}
					do_action( 'yokoo_action_after_post_readmore' );
				}
			}
			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $yokoo_template_args ) ) {
	if ( ! empty( $yokoo_template_args['slider'] ) || $yokoo_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
