<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package YOKOO
 * @since YOKOO 1.0
 */

$yokoo_template_args = get_query_var( 'yokoo_template_args' );

if ( is_array( $yokoo_template_args ) ) {
	$yokoo_columns    = empty( $yokoo_template_args['columns'] ) ? 2 : max( 1, $yokoo_template_args['columns'] );
	$yokoo_blog_style = array( $yokoo_template_args['type'], $yokoo_columns );
} else {
	$yokoo_blog_style = explode( '_', yokoo_get_theme_option( 'blog_style' ) );
	$yokoo_columns    = empty( $yokoo_blog_style[1] ) ? 2 : max( 1, $yokoo_blog_style[1] );
}
$yokoo_expanded   = ! yokoo_sidebar_present() && yokoo_get_theme_option( 'expand_content' ) == 'expand';

$yokoo_post_format = get_post_format();
$yokoo_post_format = empty( $yokoo_post_format ) ? 'standard' : str_replace( 'post-format-', '', $yokoo_post_format );

?><div class="<?php
	if ( ! empty( $yokoo_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( yokoo_is_blog_style_use_masonry( $yokoo_blog_style[0] ) ? 'masonry_item masonry_item' : 'column' ) . '-1_' . esc_attr( $yokoo_columns );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $yokoo_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $yokoo_columns )
				. ' post_layout_' . esc_attr( $yokoo_blog_style[0] )
				. ' post_layout_' . esc_attr( $yokoo_blog_style[0] ) . '_' . esc_attr( $yokoo_columns )
	);
	yokoo_add_blog_animation( $yokoo_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$yokoo_hover      = ! empty( $yokoo_template_args['hover'] ) && ! yokoo_is_inherit( $yokoo_template_args['hover'] )
							? $yokoo_template_args['hover']
							: yokoo_get_theme_option( 'image_hover' );

	$yokoo_components = ! empty( $yokoo_template_args['meta_parts'] )
							? ( is_array( $yokoo_template_args['meta_parts'] )
								? $yokoo_template_args['meta_parts']
								: explode( ',', $yokoo_template_args['meta_parts'] )
								)
							: yokoo_array_get_keys_by_value( yokoo_get_theme_option( 'meta_parts' ) );

	yokoo_show_post_featured(
		array(
			'thumb_size' => yokoo_get_thumb_size(
				'classic' == $yokoo_blog_style[0]
						? ( strpos( yokoo_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $yokoo_columns > 2 ? 'big' : 'huge' )
								: ( $yokoo_columns > 2
									? ( $yokoo_expanded ? 'med' : 'small' )
									: ( $yokoo_expanded ? 'big' : 'med' )
									)
							)
						: ( strpos( yokoo_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $yokoo_columns > 2 ? 'masonry-big' : 'full' )
								: ( $yokoo_columns <= 2 && $yokoo_expanded ? 'masonry-big' : 'masonry' )
							)
			),
			'hover'      => $yokoo_hover,
			'meta_parts' => $yokoo_components,
			'no_links'   => ! empty( $yokoo_template_args['no_links'] ),
		)
	);

	// Title and post meta
	$yokoo_show_title = get_the_title() != '';
	$yokoo_show_meta  = count( $yokoo_components ) > 0 && ! in_array( $yokoo_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $yokoo_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Categories
			if ( apply_filters( 'yokoo_filter_show_blog_categories', $yokoo_show_meta && in_array( 'categories', $yokoo_components ), array( 'categories' ), 'classic' ) ) {
				do_action( 'yokoo_action_before_post_category' );
				?>
				<div class="post_category">
					<?php
					yokoo_show_post_meta( apply_filters(
														'yokoo_filter_post_meta_args',
														array(
															'components' => 'categories',
															'seo'        => false,
															'echo'       => true,
															),
														'hover_' . $yokoo_hover, 1
														)
										);
					?>
				</div>
				<?php
				$yokoo_components = yokoo_array_delete_by_value( $yokoo_components, 'categories' );
				do_action( 'yokoo_action_after_post_category' );
			}
			// Post title
			if ( apply_filters( 'yokoo_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'yokoo_action_before_post_title' );
				if ( empty( $yokoo_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'yokoo_action_after_post_title' );
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	ob_start();
	if ( apply_filters( 'yokoo_filter_show_blog_excerpt', empty( $yokoo_template_args['hide_excerpt'] ) && yokoo_get_theme_option( 'excerpt_length' ) > 0, 'classic' ) ) {
		yokoo_show_post_content( $yokoo_template_args, '<div class="post_content_inner">', '</div>' );
	}
	$yokoo_content = ob_get_contents();
	ob_end_clean();

	yokoo_show_layout( $yokoo_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->' );

	// Post meta
	if ( apply_filters( 'yokoo_filter_show_blog_meta', $yokoo_show_meta, $yokoo_components, 'classic' ) ) {
		if ( count( $yokoo_components ) > 0 ) {
			do_action( 'yokoo_action_before_post_meta' );
			yokoo_show_post_meta(
				apply_filters(
					'yokoo_filter_post_meta_args', array(
						'components' => join( ',', $yokoo_components ),
						'seo'        => false,
						'echo'       => true,
					), $yokoo_blog_style[0], $yokoo_columns
				)
			);
			do_action( 'yokoo_action_after_post_meta' );
		}
	}
		
	// More button
	if ( apply_filters( 'yokoo_filter_show_blog_readmore', ! $yokoo_show_title, 'classic' ) ) {
		if ( empty( $yokoo_template_args['no_links'] ) ) {
			do_action( 'yokoo_action_before_post_readmore' );
			yokoo_show_post_more_link( $yokoo_template_args, '<p>', '</p>' );
			do_action( 'yokoo_action_after_post_readmore' );
		}
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
