<?php
/**
 * 'Band' template to display the content
 *
 * Used for index/archive/search.
 *
 * @package YOKOO
 * @since YOKOO 1.71.0
 */

$yokoo_template_args = get_query_var( 'yokoo_template_args' );

$yokoo_columns       = 1;

$yokoo_expanded      = ! yokoo_sidebar_present() && yokoo_get_theme_option( 'expand_content' ) == 'expand';

$yokoo_post_format   = get_post_format();
$yokoo_post_format   = empty( $yokoo_post_format ) ? 'standard' : str_replace( 'post-format-', '', $yokoo_post_format );

if ( is_array( $yokoo_template_args ) ) {
	$yokoo_columns    = empty( $yokoo_template_args['columns'] ) ? 1 : max( 1, $yokoo_template_args['columns'] );
	$yokoo_blog_style = array( $yokoo_template_args['type'], $yokoo_columns );
	if ( ! empty( $yokoo_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $yokoo_columns > 1 ) {
		?>
		<div class="column-1_<?php echo esc_attr( $yokoo_columns ); ?>">
		<?php
	}
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_band post_format_' . esc_attr( $yokoo_post_format ) );
	yokoo_add_blog_animation( $yokoo_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$yokoo_hover      = ! empty( $yokoo_template_args['hover'] ) && ! yokoo_is_inherit( $yokoo_template_args['hover'] )
							? $yokoo_template_args['hover']
							: yokoo_get_theme_option( 'image_hover' );
	$yokoo_components = ! empty( $yokoo_template_args['meta_parts'] )
							? ( is_array( $yokoo_template_args['meta_parts'] )
								? $yokoo_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $yokoo_template_args['meta_parts'] ) )
								)
							: yokoo_array_get_keys_by_value( yokoo_get_theme_option( 'meta_parts' ) );
	yokoo_show_post_featured(
		array(
			'no_links'   => ! empty( $yokoo_template_args['no_links'] ),
			'hover'      => $yokoo_hover,
			'meta_parts' => $yokoo_components,
			'thumb_bg'   => true,
			'thumb_size' => yokoo_get_thumb_size( 
								in_array( $yokoo_post_format, array( 'gallery', 'audio', 'video' ) )
									? ( strpos( yokoo_get_theme_option( 'body_style' ), 'full' ) !== false
										? 'full'
										: ( $yokoo_expanded 
											? 'big' 
											: 'med'
											)
										)
									: 'masonry-big'
								)
		)
	);

	?><div class="post_content_wrap"><?php

		// Title and post meta
		$yokoo_show_title = get_the_title() != '';
		$yokoo_show_meta  = count( $yokoo_components ) > 0 && ! in_array( $yokoo_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );
		if ( $yokoo_show_title ) {
			?>
			<div class="post_header entry-header">
				<?php
				// Categories
				if ( apply_filters( 'yokoo_filter_show_blog_categories', $yokoo_show_meta && in_array( 'categories', $yokoo_components ), array( 'categories' ), 'band' ) ) {
					do_action( 'yokoo_action_before_post_category' );
					?>
					<div class="post_category">
						<?php
						yokoo_show_post_meta( apply_filters(
															'yokoo_filter_post_meta_args',
															array(
																'components' => 'categories',
																'seo'        => false,
																'echo'       => true,
																),
															'hover_' . $yokoo_hover, 1
															)
											);
						?>
					</div>
					<?php
					$yokoo_components = yokoo_array_delete_by_value( $yokoo_components, 'categories' );
					do_action( 'yokoo_action_after_post_category' );
				}
				// Post title
				if ( apply_filters( 'yokoo_filter_show_blog_title', true, 'band' ) ) {
					do_action( 'yokoo_action_before_post_title' );
					if ( empty( $yokoo_template_args['no_links'] ) ) {
						the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
					} else {
						the_title( '<h4 class="post_title entry-title">', '</h4>' );
					}
					do_action( 'yokoo_action_after_post_title' );
				}
				?>
			</div><!-- .post_header -->
			<?php
		}

		// Post content
		if ( ! isset( $yokoo_template_args['excerpt_length'] ) && ! in_array( $yokoo_post_format, array( 'gallery', 'audio', 'video' ) ) ) {
			$yokoo_template_args['excerpt_length'] = 30;
		}
		if ( apply_filters( 'yokoo_filter_show_blog_excerpt', empty( $yokoo_template_args['hide_excerpt'] ) && yokoo_get_theme_option( 'excerpt_length' ) > 0, 'band' ) ) {
			?>
			<div class="post_content entry-content">
				<?php
				// Post content area
				yokoo_show_post_content( $yokoo_template_args, '<div class="post_content_inner">', '</div>' );
				?>
			</div><!-- .entry-content -->
			<?php
		}
		// Post meta
		if ( apply_filters( 'yokoo_filter_show_blog_meta', $yokoo_show_meta, $yokoo_components, 'band' ) ) {
			if ( count( $yokoo_components ) > 0 ) {
				do_action( 'yokoo_action_before_post_meta' );
				yokoo_show_post_meta(
					apply_filters(
						'yokoo_filter_post_meta_args', array(
							'components' => join( ',', $yokoo_components ),
							'seo'        => false,
							'echo'       => true,
						), 'band', 1
					)
				);
				do_action( 'yokoo_action_after_post_meta' );
			}
		}
		// More button
		if ( apply_filters( 'yokoo_filter_show_blog_readmore', ! $yokoo_show_title, 'band' ) ) {
			if ( empty( $yokoo_template_args['no_links'] ) ) {
				do_action( 'yokoo_action_before_post_readmore' );
				yokoo_show_post_more_link( $yokoo_template_args, '<p>', '</p>' );
				do_action( 'yokoo_action_after_post_readmore' );
			}
		}
		?>
	</div>
</article>
<?php

if ( is_array( $yokoo_template_args ) ) {
	if ( ! empty( $yokoo_template_args['slider'] ) || $yokoo_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
