<?php
/**
 * The template to display the user's avatar, bio and socials on the Author page
 *
 * @package YOKOO
 * @since YOKOO 1.71.0
 */
?>

<div class="author_page author vcard" itemprop="author" itemscope="itemscope" itemtype="<?php echo esc_attr( yokoo_get_protocol( true ) ); ?>//schema.org/Person">

	<div class="author_avatar" itemprop="image">
		<?php
		$yokoo_mult = yokoo_get_retina_multiplier();
		echo get_avatar( get_the_author_meta( 'user_email' ), 120 * $yokoo_mult );
		?>
	</div><!-- .author_avatar -->

	<h4 class="author_title" itemprop="name"><span class="fn"><?php the_author(); ?></span></h4>

	<?php
	$yokoo_author_description = get_the_author_meta( 'description' );
	if ( ! empty( $yokoo_author_description ) ) {
		?>
		<div class="author_bio" itemprop="description"><?php echo wp_kses( wpautop( $yokoo_author_description ), 'yokoo_kses_content' ); ?></div>
		<?php
	}
	?>

	<div class="author_details">
		<span class="author_posts_total">
			<?php
			$yokoo_posts_total = count_user_posts( get_the_author_meta('ID'), 'post' );	// get_the_author_posts() return posts number by post_type from first post in the result
			if ( $yokoo_posts_total > 0 ) {
				// Translators: Add the author's posts number to the message
				echo wp_kses( sprintf( _n( '%s article published', '%s articles published', $yokoo_posts_total, 'yokoo' ),
										'<span class="author_posts_total_value">' . number_format_i18n( $yokoo_posts_total ) . '</span>'
								 		),
							'yokoo_kses_content'
							);
			} else {
				esc_html_e( 'No posts published.', 'yokoo' );
			}
			?>
		</span><?php
			ob_start();
			do_action( 'yokoo_action_user_meta', 'author-page' );
			$yokoo_socials = ob_get_contents();
			ob_end_clean();
			yokoo_show_layout( $yokoo_socials,
				'<span class="author_socials"><span class="author_socials_caption">' . esc_html__( 'Follow:', 'yokoo' ) . '</span>',
				'</span>'
			);
		?>
	</div><!-- .author_details -->

</div><!-- .author_page -->
