<?php
/**
 * The template to display Admin notices
 *
 * @package YOKOO
 * @since YOKOO 1.0.1
 */

$yokoo_theme_slug = get_option( 'template' );
$yokoo_theme_obj  = wp_get_theme( $yokoo_theme_slug );
?>
<div class="yokoo_admin_notice yokoo_welcome_notice update-nag">
	<?php
	// Theme image
	$yokoo_theme_img = yokoo_get_file_url( 'screenshot.jpg' );
	if ( '' != $yokoo_theme_img ) {
		?>
		<div class="yokoo_notice_image"><img src="<?php echo esc_url( $yokoo_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'yokoo' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="yokoo_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'yokoo' ),
				$yokoo_theme_obj->get( 'Name' ) . ( YOKOO_THEME_FREE ? ' ' . __( 'Free', 'yokoo' ) : '' ),
				$yokoo_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="yokoo_notice_text">
		<p class="yokoo_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $yokoo_theme_obj->description ) );
			?>
		</p>
		<p class="yokoo_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'yokoo' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="yokoo_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=yokoo_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'yokoo' );
			?>
		</a>
		<?php		
		// Dismiss this notice
		?>
		<a href="#" data-notice="admin" class="yokoo_hide_notice"><i class="dashicons dashicons-dismiss"></i> <span class="yokoo_hide_notice_text"><?php esc_html_e( 'Dismiss', 'yokoo' ); ?></span></a>
	</div>
</div>
