<?php
/**
 * Skin Setup
 *
 * @package YOKOO
 * @since YOKOO 1.76.0
 */


//--------------------------------------------
// SKIN DEFAULTS
//--------------------------------------------

// Return theme's (skin's) default value for the specified parameter
if ( ! function_exists( 'yokoo_theme_defaults' ) ) {
	function yokoo_theme_defaults( $name='', $value='' ) {
		$defaults = array(
			'page'              => 1270,
			'page_boxed_extra'  => 60,
			'page_fullwide_max' => 1920,
			'paddings_fullwide' => 130,
			'sidebar'           => 420,
			'sidebar_gap'       => 90,
			'grid_gap'          => 50,
			'rad'               => 0,
		);
		if ( empty( $name ) ) {
			return $defaults;
		} else {
			if ( empty( $value ) && isset( $defaults[ $name ] ) ) {
				$value = $defaults[ $name ];
			}
			return $value;
		}
	}
}


// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)


//--------------------------------------------
// SKIN SETTINGS
//--------------------------------------------
if ( ! function_exists( 'yokoo_skin_setup' ) ) {
	add_action( 'after_setup_theme', 'yokoo_skin_setup', 1 );
	function yokoo_skin_setup() {
		$GLOBALS['YOKOO_STORAGE'] = array_merge( $GLOBALS['YOKOO_STORAGE'], array(

			// Key validator: market[env|loc]-vendor[axiom|ancora|themerex]
			'theme_pro_key'       => 'env-themerex',

			'theme_doc_url'       => '//yokoo.themerex.net/doc',

			'theme_demofiles_url' => '//demofiles.themerex.net/yokoo/',
			
			'theme_rate_url'      => '//themeforest.net/download',

			'theme_custom_url' => '//themerex.net/offers/?utm_source=offers&utm_medium=click&utm_campaign=themedash',

			'theme_support_url'   => '//themerex.net/support/',

			'theme_download_url'  => '//themeforest.net/item/yokoo-bike-shop-rental-wordpress-theme/26465133',            // ThemeREX

			'theme_video_url'     => '//www.youtube.com/channel/UCnFisBimrK2aIE-hnY70kCA',   // ThemeREX

			'theme_privacy_url'   => '//themerex.net/privacy-policy/',                       // ThemeREX

			'portfolio_url'       => '//themeforest.net/user/themerex/portfolio',            // ThemeREX

			// Comma separated slugs of theme-specific categories (for get relevant news in the dashboard widget)
			// (i.e. 'children,kindergarten')
			'theme_categories'    => '',
		) );
	}
}


// Add/remove/change Theme Settings
if ( ! function_exists( 'yokoo_skin_setup_settings' ) ) {
	add_action( 'after_setup_theme', 'yokoo_skin_setup_settings', 1 );
	function yokoo_skin_setup_settings() {
		// Example: enable (true) / disable (false) thumbs in the prev/next navigation
		yokoo_storage_set_array( 'settings', 'thumbs_in_navigation', true );
	}
}



//--------------------------------------------
// SKIN FONTS
//--------------------------------------------
if ( ! function_exists( 'yokoo_skin_setup_fonts' ) ) {
	add_action( 'after_setup_theme', 'yokoo_skin_setup_fonts', 1 );
	function yokoo_skin_setup_fonts() {
		// Fonts to load when theme start
		// It can be Google fonts or uploaded fonts, placed in the folder css/font-face/font-name inside the skin folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		// example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
		yokoo_storage_set(
			'load_fonts', array(
				// Google font
				array(
					'name'   => 'Noto Sans',
					'family' => 'sans-serif',
					'styles' => '400,400i,700,700i',     // Parameter 'style' used only for the Google fonts
				),
				// Font-face packed with theme
				array(
					'name'   => 'Gilroy',
					'family' => 'sans-serif',
				),
				// Google font
				array(
					'name'   => 'Montserrat',
					'family' => 'sans-serif',
					'styles' => '100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i',     // Parameter 'style' used only for the Google fonts
				),
			)
		);

		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		yokoo_storage_set( 'load_fonts_subset', 'latin,latin-ext' );

		// Settings of the main tags
		// Attention! Font name in the parameter 'font-family' will be enclosed in the quotes and no spaces after comma!
		// example:
		// Correct:   'font-family' => '"Roboto",sans-serif'
		// Incorrect: 'font-family' => '"Roboto", sans-serif'
		// Incorrect: 'font-family' => 'Roboto,sans-serif'

		$font_description = esc_html__( 'Font settings for the %s of the site. To ensure that the elements scale properly on mobile devices, please use only the following units: "rem", "em" or "ex"', 'yokoo' );

		yokoo_storage_set(
			'theme_fonts', array(
				'p'       => array(
					'title'           => esc_html__( 'Main text', 'yokoo' ),
					'description'     => sprintf( $font_description, esc_html__( 'main text', 'yokoo' ) ),
					'font-family'     => '"Noto Sans",sans-serif',
					'font-size'       => '1rem',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.75em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '',
					'margin-top'      => '0em',
					'margin-bottom'   => '1em',
				),
				'post'    => array(
					'title'           => esc_html__( 'Article text', 'yokoo' ),
					'description'     => sprintf( $font_description, esc_html__( 'article text', 'yokoo' ) ),
					'font-family'     => '',			// Example: '"PR Serif",serif',
					'font-size'       => '',			// Example: '1.286rem',
					'font-weight'     => '',			// Example: '400',
					'font-style'      => '',			// Example: 'normal',
					'line-height'     => '',			// Example: '1.75em',
					'text-decoration' => '',			// Example: 'none',
					'text-transform'  => '',			// Example: 'none',
					'letter-spacing'  => '',			// Example: '',
					'margin-top'      => '',			// Example: '0em',
					'margin-bottom'   => '',			// Example: '1.4em',
				),
				'h1'      => array(
					'title'           => esc_html__( 'Heading 1', 'yokoo' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H1', 'yokoo' ) ),
					'font-family'     => '"Gilroy",sans-serif',
					'font-size'       => '6.25em',
					'font-weight'     => '800',
					'font-style'      => 'normal',
					'line-height'     => '0.97em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.735em',
					'margin-bottom'   => '0.34em',
				),
				'h2'      => array(
					'title'           => esc_html__( 'Heading 2', 'yokoo' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H2', 'yokoo' ) ),
					'font-family'     => '"Gilroy",sans-serif',
					'font-size'       => '4.5em',
					'font-weight'     => '800',
					'font-style'      => 'normal',
					'line-height'     => '1.111em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.93em',
					'margin-bottom'   => '0.4em',
				),
				'h3'      => array(
					'title'           => esc_html__( 'Heading 3', 'yokoo' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H3', 'yokoo' ) ),
					'font-family'     => '"Gilroy",sans-serif',
					'font-size'       => '3.375em',
					'font-weight'     => '800',
					'font-style'      => 'normal',
					'line-height'     => '1.074em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.07em',
					'margin-bottom'   => '0.5em',
				),
				'h4'      => array(
					'title'           => esc_html__( 'Heading 4', 'yokoo' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H4', 'yokoo' ) ),
					'font-family'     => '"Gilroy",sans-serif',
					'font-size'       => '1.813em',
					'font-weight'     => '800',
					'font-style'      => 'normal',
					'line-height'     => '1.267em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0.5px',
					'margin-top'      => '1.78em',
					'margin-bottom'   => '0.88em',
				),
				'h5'      => array(
					'title'           => esc_html__( 'Heading 5', 'yokoo' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H5', 'yokoo' ) ),
					'font-family'     => '"Gilroy",sans-serif',
					'font-size'       => '1.563em',
					'font-weight'     => '800',
					'font-style'      => 'normal',
					'line-height'     => '1.4em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.85em',
					'margin-bottom'   => '0.75em',
				),
				'h6'      => array(
					'title'           => esc_html__( 'Heading 6', 'yokoo' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H6', 'yokoo' ) ),
					'font-family'     => '"Montserrat",sans-serif',
					'font-size'       => '1em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '2.44em',
					'margin-bottom'   => '1em',
				),
				'logo'    => array(
					'title'           => esc_html__( 'Logo text', 'yokoo' ),
					'description'     => sprintf( $font_description, esc_html__( 'text of the logo', 'yokoo' ) ),
					'font-family'     => '"Montserrat",sans-serif',
					'font-size'       => '1.8em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.25em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0.1px',
				),
				'button'  => array(
					'title'           => esc_html__( 'Buttons', 'yokoo' ),
					'description'     => sprintf( $font_description, esc_html__( 'buttons', 'yokoo' ) ),
					'font-family'     => '"Montserrat",sans-serif',
					'font-size'       => '18px',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '22px',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'input'   => array(
					'title'           => esc_html__( 'Input fields', 'yokoo' ),
					'description'     => sprintf( $font_description, esc_html__( 'input fields, dropdowns and textareas', 'yokoo' ) ),
					'font-family'     => '"Noto Sans",sans-serif',
					'font-size'       => '15px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',     // Attention! Firefox don't allow line-height less then 1.5em in the select
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'info'    => array(
					'title'           => esc_html__( 'Post meta', 'yokoo' ),
					'description'     => sprintf( $font_description, esc_html__( 'post meta (author, categories, publish date, counters, share, etc.)', 'yokoo' ) ),
					'font-family'     => 'inherit',
					'font-size'       => '14px',  // Old value '13px' don't allow using 'font zoom' in the custom blog items
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.4em',
					'margin-bottom'   => '',
				),
				'menu'    => array(
					'title'           => esc_html__( 'Main menu', 'yokoo' ),
					'description'     => sprintf( $font_description, esc_html__( 'main menu items', 'yokoo' ) ),
					'font-family'     => '"Noto Sans",sans-serif',
					'font-size'       => '17px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'submenu' => array(
					'title'           => esc_html__( 'Dropdown menu', 'yokoo' ),
					'description'     => sprintf( $font_description, esc_html__( 'dropdown menu items', 'yokoo' ) ),
					'font-family'     => '"Noto Sans",sans-serif',
					'font-size'       => '14px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
			)
		);
	}
}


//--------------------------------------------
// COLOR SCHEMES
//--------------------------------------------
if ( ! function_exists( 'yokoo_skin_setup_schemes' ) ) {
	add_action( 'after_setup_theme', 'yokoo_skin_setup_schemes', 1 );
	function yokoo_skin_setup_schemes() {

		// Theme colors for customizer
		// Attention! Inner scheme must be last in the array below
		yokoo_storage_set(
			'scheme_color_groups', array(
				'main'    => array(
					'title'       => esc_html__( 'Main', 'yokoo' ),
					'description' => esc_html__( 'Colors of the main content area', 'yokoo' ),
				),
				'alter'   => array(
					'title'       => esc_html__( 'Alter', 'yokoo' ),
					'description' => esc_html__( 'Colors of the alternative blocks (sidebars, etc.)', 'yokoo' ),
				),
				'extra'   => array(
					'title'       => esc_html__( 'Extra', 'yokoo' ),
					'description' => esc_html__( 'Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'yokoo' ),
				),
				'inverse' => array(
					'title'       => esc_html__( 'Inverse', 'yokoo' ),
					'description' => esc_html__( 'Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'yokoo' ),
				),
				'input'   => array(
					'title'       => esc_html__( 'Input', 'yokoo' ),
					'description' => esc_html__( 'Colors of the form fields (text field, textarea, select, etc.)', 'yokoo' ),
				),
			)
		);

		yokoo_storage_set(
			'scheme_color_names', array(
				'bg_color'    => array(
					'title'       => esc_html__( 'Background color', 'yokoo' ),
					'description' => esc_html__( 'Background color of this block in the normal state', 'yokoo' ),
				),
				'bg_hover'    => array(
					'title'       => esc_html__( 'Background hover', 'yokoo' ),
					'description' => esc_html__( 'Background color of this block in the hovered state', 'yokoo' ),
				),
				'bd_color'    => array(
					'title'       => esc_html__( 'Border color', 'yokoo' ),
					'description' => esc_html__( 'Border color of this block in the normal state', 'yokoo' ),
				),
				'bd_hover'    => array(
					'title'       => esc_html__( 'Border hover', 'yokoo' ),
					'description' => esc_html__( 'Border color of this block in the hovered state', 'yokoo' ),
				),
				'text'        => array(
					'title'       => esc_html__( 'Text', 'yokoo' ),
					'description' => esc_html__( 'Color of the text inside this block', 'yokoo' ),
				),
				'text_dark'   => array(
					'title'       => esc_html__( 'Text dark', 'yokoo' ),
					'description' => esc_html__( 'Color of the dark text (bold, header, etc.) inside this block', 'yokoo' ),
				),
				'text_light'  => array(
					'title'       => esc_html__( 'Text light', 'yokoo' ),
					'description' => esc_html__( 'Color of the light text (post meta, etc.) inside this block', 'yokoo' ),
				),
				'text_link'   => array(
					'title'       => esc_html__( 'Link', 'yokoo' ),
					'description' => esc_html__( 'Color of the links inside this block', 'yokoo' ),
				),
				'text_hover'  => array(
					'title'       => esc_html__( 'Link hover', 'yokoo' ),
					'description' => esc_html__( 'Color of the hovered state of links inside this block', 'yokoo' ),
				),
				'text_link2'  => array(
					'title'       => esc_html__( 'Link 2', 'yokoo' ),
					'description' => esc_html__( 'Color of the accented texts (areas) inside this block', 'yokoo' ),
				),
				'text_hover2' => array(
					'title'       => esc_html__( 'Link 2 hover', 'yokoo' ),
					'description' => esc_html__( 'Color of the hovered state of accented texts (areas) inside this block', 'yokoo' ),
				),
				'text_link3'  => array(
					'title'       => esc_html__( 'Link 3', 'yokoo' ),
					'description' => esc_html__( 'Color of the other accented texts (buttons) inside this block', 'yokoo' ),
				),
				'text_hover3' => array(
					'title'       => esc_html__( 'Link 3 hover', 'yokoo' ),
					'description' => esc_html__( 'Color of the hovered state of other accented texts (buttons) inside this block', 'yokoo' ),
				),
			)
		);

		// Default values for each color scheme
		$schemes = array(

			// Color scheme: 'default'
			'default' => array(
				'title'    => esc_html__( 'Default', 'yokoo' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#f0f2f2', //ok
					'bd_color'         => '#cdd3d3', //ok

					// Text and links colors
					'text'             => '#5D6B6D', //ok
					'text_light'       => '#1b3e41', //ok
					'text_dark'        => '#1b3e41', //ok
					'text_link'        => '#df453e', //ok
					'text_hover'       => '#1b3e41', //ok
					'text_link2'       => '#80d572',
					'text_hover2'      => '#8be77c',
					'text_link3'       => '#1b3e41', //ok
					'text_hover3'      => '#eec432',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#ffffff', //ok
					'alter_bg_hover'   => '#f6f7f7', //ok
					'alter_bd_color'   => '#f0f2f2', //ok
					'alter_bd_hover'   => '#d1dada', //ok
					'alter_text'       => '#728385', //ok
					'alter_light'      => '#97adaf',
					'alter_dark'       => '#1b3e41',
					'alter_link'       => '#df453e', //ok
					'alter_hover'      => '#1b3e41', //ok
					'alter_link2'      => '#8be77c',
					'alter_hover2'     => '#80d572',
					'alter_link3'      => '#eec432',
					'alter_hover3'     => '#ddb837',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#1b3e41', //ok
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#313131',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#A3B4B7', //ok
					'extra_light'      => '#afafaf',
					'extra_dark'       => '#A3B4B7', //ok
					'extra_link'       => '#df453e', //ok?
					'extra_hover'      => '#ffffff', //ok
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#f6f7f7', //ok
					'input_bg_hover'   => '#f6f7f7', //ok
					'input_bd_color'   => '#e2e7e7', //ok
					'input_bd_hover'   => '#cdd3d3', //ok
					'input_text'       => '#728385', //ok
					'input_light'      => '#728385', //ok
					'input_dark'       => '#728385', //ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#000000',
					'inverse_link'     => '#ffffff',
					'inverse_hover'    => '#A3B4B7', //ok

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'dark'
			'dark'    => array(
				'title'    => esc_html__( 'Dark', 'yokoo' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#163336', //ok
					'bd_color'         => '#335154', //ok

					// Text and links colors
					'text'             => '#A3B4B7', //ok
					'text_light'       => '#90a0a2',
					'text_dark'        => '#ffffff',
					'text_link'        => '#df453e', //ok
					'text_hover'       => '#ffffff', //ok
					'text_link2'       => '#80d572',
					'text_hover2'      => '#8be77c',
					'text_link3'       => '#ddb837',
					'text_hover3'      => '#eec432',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#1b3e41', //ok
					'alter_bg_hover'   => '#214346', //ok
					'alter_bd_color'   => '#163336', //ok
					'alter_bd_hover'   => '#d1dada',
					'alter_text'       => '#97adaf', //ok
					'alter_light'      => '#6f6f6f',
					'alter_dark'       => '#ffffff',
					'alter_link'       => '#df453e', //ok
					'alter_hover'      => '#ffffff', //ok
					'alter_link2'      => '#8be77c',
					'alter_hover2'     => '#80d572',
					'alter_link3'      => '#eec432',
					'alter_hover3'     => '#ddb837',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#1e1d22',
					'extra_bg_hover'   => '#28272e',
					'extra_bd_color'   => '#464646',
					'extra_bd_hover'   => '#4a4a4a',
					'extra_text'       => '#A3B4B7',
					'extra_light'      => '#6f6f6f',
					'extra_dark'       => '#A3B4B7', //ok
					'extra_link'       => '#df453e', //ok
					'extra_hover'      => '#ffffff',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#1b3e41', //ok
					'input_bg_hover'   => '#1b3e41', //ok
					'input_bd_color'   => '#335154', //ok
					'input_bd_hover'   => '#395a5d', //ok?
					'input_text'       => '#A3B4B7', //ok
					'input_light'      => '#A3B4B7', //ok
					'input_dark'       => '#A3B4B7', //ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#e36650',
					'inverse_bd_hover' => '#cb5b47',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#000000',
					'inverse_link'     => '#ffffff',
					'inverse_hover'    => '#1b3e41', //ok

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),
		);
		yokoo_storage_set( 'schemes', $schemes );
		yokoo_storage_set( 'schemes_original', $schemes );

		// Add names of additional colors
		//---> For example:
		//---> yokoo_storage_set_array( 'scheme_color_names', 'new_color1', array(
		//---> 	'title'       => __( 'New color 1', 'yokoo' ),
		//---> 	'description' => __( 'Description of the new color 1', 'yokoo' ),
		//---> ) );


		// Additional colors for each scheme
		// Parameters:	'color' - name of the color from the scheme that should be used as source for the transformation
		//				'alpha' - to make color transparent (0.0 - 1.0)
		//				'hue', 'saturation', 'brightness' - inc/dec value for each color's component
		yokoo_storage_set(
			'scheme_colors_add', array(
				'bg_color_0'        => array(
					'color' => 'bg_color',
					'alpha' => 0,
				),
				'bg_color_02'       => array(
					'color' => 'bg_color',
					'alpha' => 0.2,
				),
				'bg_color_07'       => array(
					'color' => 'bg_color',
					'alpha' => 0.7,
				),
				'bg_color_08'       => array(
					'color' => 'bg_color',
					'alpha' => 0.8,
				),
				'bg_color_09'       => array(
					'color' => 'bg_color',
					'alpha' => 0.9,
				),
				'alter_bg_color_07' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.7,
				),
				'alter_bg_color_04' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.4,
				),
				'alter_bg_color_00' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0,
				),
				'alter_bg_color_02' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.2,
				),
				'alter_bd_color_02' => array(
					'color' => 'alter_bd_color',
					'alpha' => 0.2,
				),
				'alter_link_02'     => array(
					'color' => 'alter_link',
					'alpha' => 0.2,
				),
				'alter_link_07'     => array(
					'color' => 'alter_link',
					'alpha' => 0.7,
				),
				'extra_bg_color_05' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.5,
				),
				'extra_bg_color_07' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.7,
				),
				'extra_link_02'     => array(
					'color' => 'extra_link',
					'alpha' => 0.2,
				),
				'extra_link_07'     => array(
					'color' => 'extra_link',
					'alpha' => 0.7,
				),
				'text_dark_07'      => array(
					'color' => 'text_dark',
					'alpha' => 0.7,
				),
				'text_link_02'      => array(
					'color' => 'text_link',
					'alpha' => 0.2,
				),
				'text_link_07'      => array(
					'color' => 'text_link',
					'alpha' => 0.7,
				),
				'text_link_blend'   => array(
					'color'      => 'text_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'alter_link_blend'  => array(
					'color'      => 'alter_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'text_link3_blend'   => array(
					'color'      => 'text_link3',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
			)
		);

		// Simple scheme editor: lists the colors to edit in the "Simple" mode.
		// For each color you can set the array of 'slave' colors and brightness factors that are used to generate new values,
		// when 'main' color is changed
		// Leave 'slave' arrays empty if your scheme does not have a color dependency
		yokoo_storage_set(
			'schemes_simple', array(
				'text_link'        => array(
					'alter_hover'      => 1,
					'extra_link'       => 1,
					'inverse_bd_color' => 0.85,
					'inverse_bd_hover' => 0.7,
				),
				'text_hover'       => array(
					'alter_link'  => 1,
					'extra_hover' => 1,
				),
				'text_link2'       => array(
					'alter_hover2' => 1,
					'extra_link2'  => 1,
				),
				'text_hover2'      => array(
					'alter_link2'  => 1,
					'extra_hover2' => 1,
				),
				'text_link3'       => array(
					'alter_hover3' => 1,
					'extra_link3'  => 1,
				),
				'text_hover3'      => array(
					'alter_link3'  => 1,
					'extra_hover3' => 1,
				),
				'alter_link'       => array(),
				'alter_hover'      => array(),
				'alter_link2'      => array(),
				'alter_hover2'     => array(),
				'alter_link3'      => array(),
				'alter_hover3'     => array(),
				'extra_link'       => array(),
				'extra_hover'      => array(),
				'extra_link2'      => array(),
				'extra_hover2'     => array(),
				'extra_link3'      => array(),
				'extra_hover3'     => array(),
				'inverse_bd_color' => array(),
				'inverse_bd_hover' => array(),
			)
		);

		// Parameters to set order of schemes in the css
		yokoo_storage_set(
			'schemes_sorted', array(
				'color_scheme',
				'header_scheme',
				'menu_scheme',
				'sidebar_scheme',
				'footer_scheme',
			)
		);
	}
}


//--------------------------------------------
// THUMBS
//--------------------------------------------
if ( ! function_exists( 'yokoo_skin_setup_thumbs' ) ) {
	add_action( 'after_setup_theme', 'yokoo_skin_setup_thumbs', 1 );
	function yokoo_skin_setup_thumbs() {
		yokoo_storage_set(
			'theme_thumbs', apply_filters(
				'yokoo_filter_add_thumb_sizes', array(
					// Width of the image is equal to the content area width (without sidebar)
					// Height is fixed
					'yokoo-thumb-huge'        => array(
						'size'  => array( 1270, 714, true ),
						'title' => esc_html__( 'Huge image', 'yokoo' ),
						'subst' => 'trx_addons-thumb-huge',
					),
					// Width of the image is equal to the content area width (with sidebar)
					// Height is fixed
					'yokoo-thumb-big'         => array(
						'size'  => array( 760, 428, true ),
						'title' => esc_html__( 'Large image', 'yokoo' ),
						'subst' => 'trx_addons-thumb-big',
					),

					// Width of the image is equal to the 1/3 of the content area width (without sidebar)
					// Height is fixed
					'yokoo-thumb-med'         => array(
						'size'  => array( 414, 232, true ),
						'title' => esc_html__( 'Medium image', 'yokoo' ),
						'subst' => 'trx_addons-thumb-medium',
					),

					// Small square image (for avatars in comments, etc.)
					'yokoo-thumb-tiny'        => array(
						'size'  => array( 90, 90, true ),
						'title' => esc_html__( 'Small square avatar', 'yokoo' ),
						'subst' => 'trx_addons-thumb-tiny',
					),

					// Width of the image is equal to the content area width (with sidebar)
					// Height is proportional (only downscale, not crop)
					'yokoo-thumb-masonry-big' => array(
						'size'  => array( 760, 0, false ),     // Only downscale, not crop
						'title' => esc_html__( 'Masonry Large (scaled)', 'yokoo' ),
						'subst' => 'trx_addons-thumb-masonry-big',
					),

					// Width of the image is equal to the 1/3 of the full content area width (without sidebar)
					// Height is proportional (only downscale, not crop)
					'yokoo-thumb-masonry'     => array(
						'size'  => array( 390, 0, false ),     // Only downscale, not crop
						'title' => esc_html__( 'Masonry (scaled)', 'yokoo' ),
						'subst' => 'trx_addons-thumb-masonry',
					),

					'yokoo-thumb-extra'        => array(
						'size'  => array( 760, 590, true ),
						'title' => esc_html__( 'Extra image', 'yokoo' ),
						'subst' => 'trx_addons-thumb-extra',
					),

				)
			)
		);
	}
}


//--------------------------------------------
// BLOG STYLES
//--------------------------------------------
if ( ! function_exists( 'yokoo_skin_setup_blog_styles' ) ) {
	add_action( 'after_setup_theme', 'yokoo_skin_setup_blog_styles', 1 );
	function yokoo_skin_setup_blog_styles() {

		$blog_styles = array(
			'excerpt' => array(
				'title'   => esc_html__( 'Standard', 'yokoo' ),
				'archive' => 'index',
				'item'    => 'templates/content-excerpt',
				'styles'  => 'excerpt',
				'icon'    => "images/theme-options/blog-style/excerpt.png",
			),
			'classic' => array(
				'title'   => esc_html__( 'Classic', 'yokoo' ),
				'archive' => 'index',
				'item'    => 'templates/content-classic',
				'columns' => array( 2, 3, 4 ),
				'styles'  => 'classic',
				'icon'    => "images/theme-options/blog-style/classic-%d.png",
				'new_row' => true,
			),
		);
		if ( ! YOKOO_THEME_FREE ) {
			$blog_styles['classic-masonry']   = array(
				'title'   => esc_html__( 'Classic Masonry', 'yokoo' ),
				'archive' => 'index',
				'item'    => 'templates/content-classic',
				'columns' => array( 2, 3, 4 ),
				'styles'  => array( 'classic', 'masonry' ),
				'scripts' => 'masonry',
				'icon'    => "images/theme-options/blog-style/classic-masonry-%d.png",
				'new_row' => true,
			);
			$blog_styles['portfolio'] = array(
				'title'   => esc_html__( 'Portfolio', 'yokoo' ),
				'archive' => 'index',
				'item'    => 'templates/content-portfolio',
				'columns' => array( 2, 3, 4 ),
				'styles'  => 'portfolio',
				'icon'    => "images/theme-options/blog-style/portfolio-%d.png",
				'new_row' => true,
			);
			$blog_styles['portfolio-masonry'] = array(
				'title'   => esc_html__( 'Portfolio Masonry', 'yokoo' ),
				'archive' => 'index',
				'item'    => 'templates/content-portfolio',
				'columns' => array( 2, 3, 4 ),
				'styles'  => array( 'portfolio', 'masonry' ),
				'scripts' => 'masonry',
				'icon'    => "images/theme-options/blog-style/portfolio-masonry-%d.png",
				'new_row' => true,
			);
		}
		yokoo_storage_set( 'blog_styles', apply_filters( 'yokoo_filter_add_blog_styles', $blog_styles ) );
	}
}


//--------------------------------------------
// SINGLE STYLES
//--------------------------------------------
if ( ! function_exists( 'yokoo_skin_setup_single_styles' ) ) {
	add_action( 'after_setup_theme', 'yokoo_skin_setup_single_styles', 1 );
	function yokoo_skin_setup_single_styles() {

		yokoo_storage_set( 'single_styles', apply_filters( 'yokoo_filter_add_single_styles', array(
			'style-1'   => array(
				'title'       => esc_html__( 'Style 1', 'yokoo' ),
				'description' => esc_html__( 'Fullwidth image is above the content area, the title and meta are over the image', 'yokoo' ),
				'styles'      => 'style-1',
				'icon'        => "images/theme-options/single-style/style-1.png",
			),
			'style-2'   => array(
				'title'       => esc_html__( 'Style 2', 'yokoo' ),
				'description' => esc_html__( 'Fullwidth image is above the content area, the title and meta are inside the content area', 'yokoo' ),
				'styles'      => 'style-2',
				'icon'        => "images/theme-options/single-style/style-2.png",
			),
			'style-3'   => array(
				'title'       => esc_html__( 'Style 3', 'yokoo' ),
				'description' => esc_html__( 'Fullwidth image is above the content area, the title and meta are below the image', 'yokoo' ),
				'styles'      => 'style-3',
				'icon'        => "images/theme-options/single-style/style-3.png",
			),
			'style-4'   => array(
				'title'       => esc_html__( 'Style 4', 'yokoo' ),
				'description' => esc_html__( 'Boxed image is above the content area, the title and meta are above the image', 'yokoo' ),
				'styles'      => 'style-4',
				'icon'        => "images/theme-options/single-style/style-4.png",
			),
			'style-5'   => array(
				'title'       => esc_html__( 'Style 5', 'yokoo' ),
				'description' => esc_html__( 'Boxed image is inside the content area, the title and meta are above the content area', 'yokoo' ),
				'styles'      => 'style-5',
				'icon'        => "images/theme-options/single-style/style-5.png",
			),
			'style-6'   => array(
				'title'       => esc_html__( 'Style 6', 'yokoo' ),
				'description' => esc_html__( 'Boxed image, the title and meta are inside the content area, the title and meta are above the image', 'yokoo' ),
				'styles'      => 'style-6',
				'icon'        => "images/theme-options/single-style/style-6.png",
			),
		) ) );
	}
}
