<?php
/**
 * Required plugins
 *
 * @package YOKOO
 * @since YOKOO 1.76.0
 */

// THEME-SUPPORTED PLUGINS
// If plugin not need - remove its settings from next array
//----------------------------------------------------------
$yokoo_theme_required_plugins_groups = array(
	'core'          => esc_html__( 'Core', 'yokoo' ),
	'page_builders' => esc_html__( 'Page Builders', 'yokoo' ),
	'ecommerce'     => esc_html__( 'E-Commerce & Donations', 'yokoo' ),
	'socials'       => esc_html__( 'Socials and Communities', 'yokoo' ),
	'events'        => esc_html__( 'Events and Appointments', 'yokoo' ),
	'content'       => esc_html__( 'Content', 'yokoo' ),
	'other'         => esc_html__( 'Other', 'yokoo' ),
);
$yokoo_theme_required_plugins        = array(
	'trx_addons'                 => array(
		'title'       => esc_html__( 'ThemeREX Addons', 'yokoo' ),
		'description' => esc_html__( "Will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options", 'yokoo' ),
		'required'    => true,
		'logo'        => 'trx_addons.png',
		'group'       => $yokoo_theme_required_plugins_groups['core'],
	),
	'elementor'                  => array(
		'title'       => esc_html__( 'Elementor', 'yokoo' ),
		'description' => esc_html__( "Is a beautiful PageBuilder, even the free version of which allows you to create great pages using a variety of modules.", 'yokoo' ),
		'required'    => false,
		'logo'        => 'elementor.png',
		'group'       => $yokoo_theme_required_plugins_groups['page_builders'],
	),
	'gutenberg'                  => array(
		'title'       => esc_html__( 'Gutenberg', 'yokoo' ),
		'description' => esc_html__( "It's a posts editor coming in place of the classic TinyMCE. Can be installed and used in parallel with Elementor", 'yokoo' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'gutenberg.png',
		'group'       => $yokoo_theme_required_plugins_groups['page_builders'],
	),
	'woocommerce'                => array(
		'title'       => esc_html__( 'WooCommerce', 'yokoo' ),
		'description' => esc_html__( "Connect the store to your website and start selling now", 'yokoo' ),
		'required'    => false,
		'logo'        => 'woocommerce.png',
		'group'       => $yokoo_theme_required_plugins_groups['ecommerce'],
	),
	'woocommerce-products-filter'                => array(
		'title'       => esc_html__( 'WOOF – Products Filter for WooCommerce', 'yokoo' ),
		'description' => esc_html__( "WOOF is product search plugin for WooCommerce that allows your site customers filter products by categories, attributes, products tags, products custom taxonomies and price.", 'yokoo' ),
		'required'    => false,
		'logo'        => yokoo_get_file_url( 'plugins/woocommerce-products-filter/woocommerce-products-filter.jpg' ),
		'group'       => $yokoo_theme_required_plugins_groups['ecommerce'],
	),
	'elegro-payment'             => array(
		'title'       => esc_html__( 'Elegro Crypto Payment', 'yokoo' ),
		'description' => esc_html__( "Extends WooCommerce Payment Gateways with an elegro Crypto Payment", 'yokoo' ),
		'required'    => false,
		'logo'        => 'elegro-payment.png',
		'group'       => $yokoo_theme_required_plugins_groups['ecommerce'],
	),
	'mailchimp-for-wp'           => array(
		'title'       => esc_html__( 'MailChimp for WP', 'yokoo' ),
		'description' => esc_html__( "Allows visitors to subscribe to newsletters", 'yokoo' ),
		'required'    => false,
		'logo'        => 'mailchimp-for-wp.png',
		'group'       => $yokoo_theme_required_plugins_groups['socials'],
	),
	'the-events-calendar'        => array(
		'title'       => esc_html__( 'The Events Calendar', 'yokoo' ),
		'description' => '',
		'required'    => false,
		'logo'        => 'the-events-calendar.png',
		'group'       => $yokoo_theme_required_plugins_groups['events'],
	),
	'contact-form-7'             => array(
		'title'       => esc_html__( 'Contact Form 7', 'yokoo' ),
		'description' => esc_html__( "CF7 allows you to create an unlimited number of contact forms", 'yokoo' ),
		'required'    => false,
		'logo'        => 'contact-form-7.png',
		'group'       => $yokoo_theme_required_plugins_groups['content'],
	),
	'date-time-picker-field'             => array(
		'title'       => esc_html__( 'Date Time Picker Field', 'yokoo' ),
		'description' => esc_html__( "Convert any input field on your website into a date time picker field using CSS selectors", 'yokoo' ),
		'required'    => false,
		'logo'        => false,
		'group'       => $yokoo_theme_required_plugins_groups['content'],
	),
	'essential-grid'             => array(
		'title'       => esc_html__( 'Essential Grid', 'yokoo' ),
		'description' => '',
		'required'    => false,
		'logo'        => 'essential-grid.png',
		'group'       => $yokoo_theme_required_plugins_groups['content'],
	),
	'revslider'                  => array(
		'title'       => esc_html__( 'Revolution Slider', 'yokoo' ),
		'description' => '',
		'required'    => false,
		'logo'        => 'revslider.png',
		'group'       => $yokoo_theme_required_plugins_groups['content'],
	),
	'sitepress-multilingual-cms' => array(
		'title'       => esc_html__( 'WPML - Sitepress Multilingual CMS', 'yokoo' ),
		'description' => esc_html__( "Allows you to make your website multilingual", 'yokoo' ),
		'required'    => false,
		'install'     => false,      // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'sitepress-multilingual-cms.png',
		'group'       => $yokoo_theme_required_plugins_groups['content'],
	),
	'wp-gdpr-compliance'         => array(
		'title'       => esc_html__( 'Cookie Information', 'yokoo' ),
		'description' => esc_html__( "Allow visitors to decide for themselves what personal data they want to store on your site", 'yokoo' ),
		'required'    => false,
		'logo'        => 'wp-gdpr-compliance.png',
		'group'       => $yokoo_theme_required_plugins_groups['other'],
	),
	'trx_updater'                => array(
		'title'       => esc_html__( 'ThemeREX Updater', 'yokoo' ),
		'description' => esc_html__( "Update theme and theme-specific plugins from developer's upgrade server.", 'yokoo' ),
		'required'    => false,
		'logo'        => 'trx_updater.png',
		'group'       => $yokoo_theme_required_plugins_groups['other'],
	),
	'trx_popup'                  => array(
		'title'       => esc_html__( 'ThemeREX Popup', 'yokoo' ),
		'description' => esc_html__( "Add popup to your site.", 'yokoo' ),
		'required'    => false,
		'logo'        => 'trx_popup.png',
		'group'       => $yokoo_theme_required_plugins_groups['other'],
	),
	'instagram-feed'             => array(
		'title'       => esc_html__( 'Instagram Feed', 'yokoo' ),
		'description' => esc_html__( "Displays the latest photos from your profile on Instagram", 'yokoo' ),
		'required'    => false,
		'logo'        => 'instagram-feed.png',
		'group'       => $yokoo_theme_required_plugins_groups['socials'],
	)
);

if ( YOKOO_THEME_FREE ) {
	unset( $yokoo_theme_required_plugins['js_composer'] );
	unset( $yokoo_theme_required_plugins['vc-extensions-bundle'] );
	unset( $yokoo_theme_required_plugins['easy-digital-downloads'] );
	unset( $yokoo_theme_required_plugins['give'] );
	unset( $yokoo_theme_required_plugins['bbpress'] );
	unset( $yokoo_theme_required_plugins['booked'] );
	unset( $yokoo_theme_required_plugins['content_timeline'] );
	unset( $yokoo_theme_required_plugins['mp-timetable'] );
	unset( $yokoo_theme_required_plugins['learnpress'] );
	unset( $yokoo_theme_required_plugins['the-events-calendar'] );
	unset( $yokoo_theme_required_plugins['calculated-fields-form'] );
	unset( $yokoo_theme_required_plugins['essential-grid'] );
	unset( $yokoo_theme_required_plugins['revslider'] );
	unset( $yokoo_theme_required_plugins['ubermenu'] );
	unset( $yokoo_theme_required_plugins['sitepress-multilingual-cms'] );
	unset( $yokoo_theme_required_plugins['envato-market'] );
	unset( $yokoo_theme_required_plugins['trx_updater'] );
	unset( $yokoo_theme_required_plugins['trx_popup'] );
}

// Add plugins list to the global storage
yokoo_storage_set( 'required_plugins', $yokoo_theme_required_plugins );
