<?php
/* Instagram Feed support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'yokoo_filter_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'yokoo_filter_theme_setup9', 9 );
	function yokoo_filter_theme_setup9() {
		if ( is_admin() ) {
			add_filter( 'yokoo_filter_tgmpa_required_plugins', 'yokoo_filter_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'yokoo_filter_tgmpa_required_plugins' ) ) {
	
	function yokoo_filter_tgmpa_required_plugins( $list = array() ) {
		if ( yokoo_storage_isset( 'required_plugins', 'woocommerce-products-filter' ) && yokoo_storage_get_array( 'required_plugins', 'woocommerce-products-filter', 'install' ) !== false ) {
			$list[] = array(
				'name'     => yokoo_storage_get_array( 'required_plugins', 'woocommerce-products-filter', 'title' ),
				'slug'     => 'woocommerce-products-filter',
				'required' => false,
			);
		}
		return $list;
	}
}

// Check if Instagram Feed installed and activated
if ( ! function_exists( 'yokoo_exists_filter' ) ) {
	function yokoo_exists_filter() {
		return defined( 'WOOF_PATH' );
	}
}

/* Import Options */
// Set plugin's specific importer options
if ( !function_exists( 'yokoo_filter_importer_set_options' ) ) {
	add_filter( 'trx_addons_filter_importer_options',	'yokoo_filter_importer_set_options' );
	function yokoo_filter_importer_set_options($options=array()) {
		if ( yokoo_exists_filter() && yokoo_storage_isset( 'required_plugins', 'woocommerce-products-filter' ) ) {
			$options['additional_options'][]	= 'woof_%';
		}
		return $options;
	}
}