<?php
/**
 * The template to display single post
 *
 * @package YOKOO
 * @since YOKOO 1.0
 */

// Full post loading
$full_post_loading        = yokoo_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading        = yokoo_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type   = yokoo_get_theme_option( 'posts_navigation_scroll_which_block' );

// Position of the related posts
$yokoo_related_position = yokoo_get_theme_option( 'related_position' );

// Type of the prev/next post navigation
$yokoo_posts_navigation = yokoo_get_theme_option( 'posts_navigation' );
$yokoo_prev_post        = false;

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( yokoo_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	yokoo_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $yokoo_posts_navigation ) {
		$yokoo_prev_post = get_previous_post( true );         // Get post from same category
		if ( ! $yokoo_prev_post ) {
			$yokoo_prev_post = get_previous_post( false );    // Get post from any category
			if ( ! $yokoo_prev_post ) {
				$yokoo_posts_navigation = 'links';
			}
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $yokoo_prev_post ) ) {
		yokoo_sc_layouts_showed( 'featured', false );
		yokoo_sc_layouts_showed( 'title', false );
		yokoo_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $yokoo_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'yokoo_filter_get_template_part', 'templates/content', 'single-' . yokoo_get_theme_option( 'single_style' ) ), 'single-' . yokoo_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $yokoo_related_position, 'inside' ) === 0 ) {
		$yokoo_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'yokoo_action_related_posts' );
		$yokoo_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $yokoo_related_content ) ) {
			$yokoo_related_position_inside = max( 0, min( 9, yokoo_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $yokoo_related_position_inside ) {
				$yokoo_related_position_inside = mt_rand( 1, 9 );
			}

			$yokoo_p_number         = 0;
			$yokoo_related_inserted = false;
			$yokoo_in_block         = false;
			$yokoo_content_start    = strpos( $yokoo_content, '<div class="post_content' );
			$yokoo_content_end      = strpos( $yokoo_content, '</div><!-- .entry-content -->' );

			for ( $i = max( 0, $yokoo_content_start ); $i < min( strlen( $yokoo_content ) - 3, $yokoo_content_end ); $i++ ) {
				if ( $yokoo_content[ $i ] != '<' ) {
					continue;
				}
				if ( $yokoo_in_block ) {
					if ( strtolower( substr( $yokoo_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$yokoo_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $yokoo_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $yokoo_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$yokoo_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $yokoo_content[ $i + 1 ] && in_array( $yokoo_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$yokoo_p_number++;
					if ( $yokoo_related_position_inside == $yokoo_p_number ) {
						$yokoo_related_inserted = true;
						$yokoo_content = ( $i > 0 ? substr( $yokoo_content, 0, $i ) : '' )
							. $yokoo_related_content
							. substr( $yokoo_content, $i );
					}
				}
			}
			if ( ! $yokoo_related_inserted ) {
				if ( $yokoo_content_end > 0 ) {
					$yokoo_content = substr( $yokoo_content, 0, $yokoo_content_end ) . $yokoo_related_content . substr( $yokoo_content, $yokoo_content_end );
				} else {
					$yokoo_content .= $yokoo_related_content;
				}
			}
		}

		yokoo_show_layout( $yokoo_content );
	}

	// Comments
	do_action( 'yokoo_action_before_comments' );
	comments_template();
	do_action( 'yokoo_action_after_comments' );

	// Related posts
	if ( 'below_content' == $yokoo_related_position
		&& ( 'scroll' != $yokoo_posts_navigation || yokoo_get_theme_option( 'posts_navigation_scroll_hide_related' ) == 0 )
		&& ( ! $full_post_loading || yokoo_get_theme_option( 'open_full_post_hide_related' ) == 0 )
	) {
		do_action( 'yokoo_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $yokoo_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $yokoo_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $yokoo_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $yokoo_prev_post ) ); ?>">
		</div>
		<?php
	}
}

get_footer();
