<?php
/* Mail Chimp support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'yokoo_mailchimp_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'yokoo_mailchimp_theme_setup9', 9 );
	function yokoo_mailchimp_theme_setup9() {
		if ( yokoo_exists_mailchimp() ) {
			add_action( 'wp_enqueue_scripts', 'yokoo_mailchimp_frontend_scripts', 1100 );
			add_filter( 'yokoo_filter_merge_styles', 'yokoo_mailchimp_merge_styles' );
		}
		if ( is_admin() ) {
			add_filter( 'yokoo_filter_tgmpa_required_plugins', 'yokoo_mailchimp_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'yokoo_mailchimp_tgmpa_required_plugins' ) ) {
	
	function yokoo_mailchimp_tgmpa_required_plugins( $list = array() ) {
		if ( yokoo_storage_isset( 'required_plugins', 'mailchimp-for-wp' ) && yokoo_storage_get_array( 'required_plugins', 'mailchimp-for-wp', 'install' ) !== false ) {
			$list[] = array(
				'name'     => yokoo_storage_get_array( 'required_plugins', 'mailchimp-for-wp', 'title' ),
				'slug'     => 'mailchimp-for-wp',
				'required' => false,
			);
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( ! function_exists( 'yokoo_exists_mailchimp' ) ) {
	function yokoo_exists_mailchimp() {
		return function_exists( '__mc4wp_load_plugin' ) || defined( 'MC4WP_VERSION' );
	}
}



// Custom styles and scripts
//------------------------------------------------------------------------

// Enqueue styles for frontend
if ( ! function_exists( 'yokoo_mailchimp_frontend_scripts' ) ) {
	
	function yokoo_mailchimp_frontend_scripts() {
		if ( yokoo_is_on( yokoo_get_theme_option( 'debug_mode' ) ) ) {
			$yokoo_url = yokoo_get_file_url( 'plugins/mailchimp-for-wp/mailchimp-for-wp.css' );
			if ( '' != $yokoo_url ) {
				wp_enqueue_style( 'yokoo-mailchimp-for-wp', $yokoo_url, array(), null );
			}
		}
	}
}

// Merge custom styles
if ( ! function_exists( 'yokoo_mailchimp_merge_styles' ) ) {
	
	function yokoo_mailchimp_merge_styles( $list ) {
		$list[] = 'plugins/mailchimp-for-wp/mailchimp-for-wp.css';
		return $list;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if ( yokoo_exists_mailchimp() ) {
	require_once yokoo_get_file_dir( 'plugins/mailchimp-for-wp/mailchimp-for-wp-style.php' );
}

