<?php
/* Instagram Feed support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'yokoo_instagram_feed_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'yokoo_instagram_feed_theme_setup9', 9 );
	function yokoo_instagram_feed_theme_setup9() {
		if ( yokoo_exists_instagram_feed() ) {
			add_action( 'wp_enqueue_scripts', 'yokoo_instagram_responsive_styles', 2000 );
			add_filter( 'yokoo_filter_merge_styles_responsive', 'yokoo_instagram_merge_styles_responsive' );
		}
		if ( is_admin() ) {
			add_filter( 'yokoo_filter_tgmpa_required_plugins', 'yokoo_instagram_feed_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'yokoo_instagram_feed_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('yokoo_filter_tgmpa_required_plugins',	'yokoo_instagram_feed_tgmpa_required_plugins');
	function yokoo_instagram_feed_tgmpa_required_plugins( $list = array() ) {
		if ( yokoo_storage_isset( 'required_plugins', 'instagram-feed' ) && yokoo_storage_get_array( 'required_plugins', 'instagram-feed', 'install' ) !== false ) {
			$list[] = array(
				'name'     => yokoo_storage_get_array( 'required_plugins', 'instagram-feed', 'title' ),
				'slug'     => 'instagram-feed',
				'required' => false,
			);
		}
		return $list;
	}
}

// Check if Instagram Feed installed and activated
if ( ! function_exists( 'yokoo_exists_instagram_feed' ) ) {
	function yokoo_exists_instagram_feed() {
		return defined( 'SBIVER' );
	}
}

// Enqueue responsive styles for frontend
if ( ! function_exists( 'yokoo_instagram_responsive_styles' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'yokoo_instagram_responsive_styles', 2000 );
	function yokoo_instagram_responsive_styles() {
		if ( yokoo_is_on( yokoo_get_theme_option( 'debug_mode' ) ) ) {
			$yokoo_url = yokoo_get_file_url( 'plugins/instagram/instagram-responsive.css' );
			if ( '' != $yokoo_url ) {
				wp_enqueue_style( 'yokoo-instagram-responsive', $yokoo_url, array(), null );
			}
		}
	}
}

// Merge responsive styles
if ( ! function_exists( 'yokoo_instagram_merge_styles_responsive' ) ) {
	//Handler of the add_filter('yokoo_filter_merge_styles_responsive', 'yokoo_instagram_merge_styles_responsive');
	function yokoo_instagram_merge_styles_responsive( $list ) {
		$list[] = 'plugins/instagram/instagram-responsive.css';
		return $list;
	}
}

