<?php
/**
 * Theme storage manipulations
 *
 * @package YOKOO
 * @since YOKOO 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) {
	exit; }

// Get theme variable
if ( ! function_exists( 'yokoo_storage_get' ) ) {
	function yokoo_storage_get( $var_name, $default = '' ) {
		global $YOKOO_STORAGE;
		return isset( $YOKOO_STORAGE[ $var_name ] ) ? $YOKOO_STORAGE[ $var_name ] : $default;
	}
}

// Set theme variable
if ( ! function_exists( 'yokoo_storage_set' ) ) {
	function yokoo_storage_set( $var_name, $value ) {
		global $YOKOO_STORAGE;
		$YOKOO_STORAGE[ $var_name ] = $value;
	}
}

// Check if theme variable is empty
if ( ! function_exists( 'yokoo_storage_empty' ) ) {
	function yokoo_storage_empty( $var_name, $key = '', $key2 = '' ) {
		global $YOKOO_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			return empty( $YOKOO_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			return empty( $YOKOO_STORAGE[ $var_name ][ $key ] );
		} else {
			return empty( $YOKOO_STORAGE[ $var_name ] );
		}
	}
}

// Check if theme variable is set
if ( ! function_exists( 'yokoo_storage_isset' ) ) {
	function yokoo_storage_isset( $var_name, $key = '', $key2 = '' ) {
		global $YOKOO_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			return isset( $YOKOO_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			return isset( $YOKOO_STORAGE[ $var_name ][ $key ] );
		} else {
			return isset( $YOKOO_STORAGE[ $var_name ] );
		}
	}
}

// Delete theme variable
if ( ! function_exists( 'yokoo_storage_unset' ) ) {
	function yokoo_storage_unset( $var_name, $key = '', $key2 = '' ) {
		global $YOKOO_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			unset( $YOKOO_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			unset( $YOKOO_STORAGE[ $var_name ][ $key ] );
		} else {
			unset( $YOKOO_STORAGE[ $var_name ] );
		}
	}
}

// Inc/Dec theme variable with specified value
if ( ! function_exists( 'yokoo_storage_inc' ) ) {
	function yokoo_storage_inc( $var_name, $value = 1 ) {
		global $YOKOO_STORAGE;
		if ( empty( $YOKOO_STORAGE[ $var_name ] ) ) {
			$YOKOO_STORAGE[ $var_name ] = 0;
		}
		$YOKOO_STORAGE[ $var_name ] += $value;
	}
}

// Concatenate theme variable with specified value
if ( ! function_exists( 'yokoo_storage_concat' ) ) {
	function yokoo_storage_concat( $var_name, $value ) {
		global $YOKOO_STORAGE;
		if ( empty( $YOKOO_STORAGE[ $var_name ] ) ) {
			$YOKOO_STORAGE[ $var_name ] = '';
		}
		$YOKOO_STORAGE[ $var_name ] .= $value;
	}
}

// Get array (one or two dim) element
if ( ! function_exists( 'yokoo_storage_get_array' ) ) {
	function yokoo_storage_get_array( $var_name, $key, $key2 = '', $default = '' ) {
		global $YOKOO_STORAGE;
		if ( empty( $key2 ) ) {
			return ! empty( $var_name ) && ! empty( $key ) && isset( $YOKOO_STORAGE[ $var_name ][ $key ] ) ? $YOKOO_STORAGE[ $var_name ][ $key ] : $default;
		} else {
			return ! empty( $var_name ) && ! empty( $key ) && isset( $YOKOO_STORAGE[ $var_name ][ $key ][ $key2 ] ) ? $YOKOO_STORAGE[ $var_name ][ $key ][ $key2 ] : $default;
		}
	}
}

// Set array element
if ( ! function_exists( 'yokoo_storage_set_array' ) ) {
	function yokoo_storage_set_array( $var_name, $key, $value ) {
		global $YOKOO_STORAGE;
		if ( ! isset( $YOKOO_STORAGE[ $var_name ] ) ) {
			$YOKOO_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			$YOKOO_STORAGE[ $var_name ][] = $value;
		} else {
			$YOKOO_STORAGE[ $var_name ][ $key ] = $value;
		}
	}
}

// Set two-dim array element
if ( ! function_exists( 'yokoo_storage_set_array2' ) ) {
	function yokoo_storage_set_array2( $var_name, $key, $key2, $value ) {
		global $YOKOO_STORAGE;
		if ( ! isset( $YOKOO_STORAGE[ $var_name ] ) ) {
			$YOKOO_STORAGE[ $var_name ] = array();
		}
		if ( ! isset( $YOKOO_STORAGE[ $var_name ][ $key ] ) ) {
			$YOKOO_STORAGE[ $var_name ][ $key ] = array();
		}
		if ( '' === $key2 ) {
			$YOKOO_STORAGE[ $var_name ][ $key ][] = $value;
		} else {
			$YOKOO_STORAGE[ $var_name ][ $key ][ $key2 ] = $value;
		}
	}
}

// Merge array elements
if ( ! function_exists( 'yokoo_storage_merge_array' ) ) {
	function yokoo_storage_merge_array( $var_name, $key, $value ) {
		global $YOKOO_STORAGE;
		if ( ! isset( $YOKOO_STORAGE[ $var_name ] ) ) {
			$YOKOO_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			$YOKOO_STORAGE[ $var_name ] = array_merge( $YOKOO_STORAGE[ $var_name ], $value );
		} else {
			$YOKOO_STORAGE[ $var_name ][ $key ] = array_merge( $YOKOO_STORAGE[ $var_name ][ $key ], $value );
		}
	}
}

// Add array element after the key
if ( ! function_exists( 'yokoo_storage_set_array_after' ) ) {
	function yokoo_storage_set_array_after( $var_name, $after, $key, $value = '' ) {
		global $YOKOO_STORAGE;
		if ( ! isset( $YOKOO_STORAGE[ $var_name ] ) ) {
			$YOKOO_STORAGE[ $var_name ] = array();
		}
		if ( is_array( $key ) ) {
			yokoo_array_insert_after( $YOKOO_STORAGE[ $var_name ], $after, $key );
		} else {
			yokoo_array_insert_after( $YOKOO_STORAGE[ $var_name ], $after, array( $key => $value ) );
		}
	}
}

// Add array element before the key
if ( ! function_exists( 'yokoo_storage_set_array_before' ) ) {
	function yokoo_storage_set_array_before( $var_name, $before, $key, $value = '' ) {
		global $YOKOO_STORAGE;
		if ( ! isset( $YOKOO_STORAGE[ $var_name ] ) ) {
			$YOKOO_STORAGE[ $var_name ] = array();
		}
		if ( is_array( $key ) ) {
			yokoo_array_insert_before( $YOKOO_STORAGE[ $var_name ], $before, $key );
		} else {
			yokoo_array_insert_before( $YOKOO_STORAGE[ $var_name ], $before, array( $key => $value ) );
		}
	}
}

// Push element into array
if ( ! function_exists( 'yokoo_storage_push_array' ) ) {
	function yokoo_storage_push_array( $var_name, $key, $value ) {
		global $YOKOO_STORAGE;
		if ( ! isset( $YOKOO_STORAGE[ $var_name ] ) ) {
			$YOKOO_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			array_push( $YOKOO_STORAGE[ $var_name ], $value );
		} else {
			if ( ! isset( $YOKOO_STORAGE[ $var_name ][ $key ] ) ) {
				$YOKOO_STORAGE[ $var_name ][ $key ] = array();
			}
			array_push( $YOKOO_STORAGE[ $var_name ][ $key ], $value );
		}
	}
}

// Pop element from array
if ( ! function_exists( 'yokoo_storage_pop_array' ) ) {
	function yokoo_storage_pop_array( $var_name, $key = '', $defa = '' ) {
		global $YOKOO_STORAGE;
		$rez = $defa;
		if ( '' === $key ) {
			if ( isset( $YOKOO_STORAGE[ $var_name ] ) && is_array( $YOKOO_STORAGE[ $var_name ] ) && count( $YOKOO_STORAGE[ $var_name ] ) > 0 ) {
				$rez = array_pop( $YOKOO_STORAGE[ $var_name ] );
			}
		} else {
			if ( isset( $YOKOO_STORAGE[ $var_name ][ $key ] ) && is_array( $YOKOO_STORAGE[ $var_name ][ $key ] ) && count( $YOKOO_STORAGE[ $var_name ][ $key ] ) > 0 ) {
				$rez = array_pop( $YOKOO_STORAGE[ $var_name ][ $key ] );
			}
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if ( ! function_exists( 'yokoo_storage_inc_array' ) ) {
	function yokoo_storage_inc_array( $var_name, $key, $value = 1 ) {
		global $YOKOO_STORAGE;
		if ( ! isset( $YOKOO_STORAGE[ $var_name ] ) ) {
			$YOKOO_STORAGE[ $var_name ] = array();
		}
		if ( empty( $YOKOO_STORAGE[ $var_name ][ $key ] ) ) {
			$YOKOO_STORAGE[ $var_name ][ $key ] = 0;
		}
		$YOKOO_STORAGE[ $var_name ][ $key ] += $value;
	}
}

// Concatenate array element with specified value
if ( ! function_exists( 'yokoo_storage_concat_array' ) ) {
	function yokoo_storage_concat_array( $var_name, $key, $value ) {
		global $YOKOO_STORAGE;
		if ( ! isset( $YOKOO_STORAGE[ $var_name ] ) ) {
			$YOKOO_STORAGE[ $var_name ] = array();
		}
		if ( empty( $YOKOO_STORAGE[ $var_name ][ $key ] ) ) {
			$YOKOO_STORAGE[ $var_name ][ $key ] = '';
		}
		$YOKOO_STORAGE[ $var_name ][ $key ] .= $value;
	}
}

// Call object's method
if ( ! function_exists( 'yokoo_storage_call_obj_method' ) ) {
	function yokoo_storage_call_obj_method( $var_name, $method, $param = null ) {
		global $YOKOO_STORAGE;
		if ( null === $param ) {
			return ! empty( $var_name ) && ! empty( $method ) && isset( $YOKOO_STORAGE[ $var_name ] ) ? $YOKOO_STORAGE[ $var_name ]->$method() : '';
		} else {
			return ! empty( $var_name ) && ! empty( $method ) && isset( $YOKOO_STORAGE[ $var_name ] ) ? $YOKOO_STORAGE[ $var_name ]->$method( $param ) : '';
		}
	}
}

// Get object's property
if ( ! function_exists( 'yokoo_storage_get_obj_property' ) ) {
	function yokoo_storage_get_obj_property( $var_name, $prop, $default = '' ) {
		global $YOKOO_STORAGE;
		return ! empty( $var_name ) && ! empty( $prop ) && isset( $YOKOO_STORAGE[ $var_name ]->$prop ) ? $YOKOO_STORAGE[ $var_name ]->$prop : $default;
	}
}
