<?php
/**
 * The Header: Logo and main menu
 *
 * @package YOKOO
 * @since YOKOO 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js
									<?php
										// Class scheme_xxx need in the <html> as context for the <body>!
										echo ' scheme_' . esc_attr( yokoo_get_theme_option( 'color_scheme' ) );
									?>
										">
<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'yokoo_action_before_body' );
	?>

	<div class="body_wrap">

		<div class="page_wrap">
			
			<?php
			$yokoo_full_post_loading = ( is_singular( 'post' ) || is_singular( 'attachment' ) ) && yokoo_get_value_gp( 'action' ) == 'full_post_loading';
			$yokoo_prev_post_loading = ( is_singular( 'post' ) || is_singular( 'attachment' ) ) && yokoo_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $yokoo_full_post_loading && ! $yokoo_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="yokoo_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="1"><?php esc_html_e( "Skip to content", 'yokoo' ); ?></a>
				<?php if ( yokoo_sidebar_present() ) { ?>
				<a class="yokoo_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="1"><?php esc_html_e( "Skip to sidebar", 'yokoo' ); ?></a>
				<?php } ?>
				<a class="yokoo_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="1"><?php esc_html_e( "Skip to footer", 'yokoo' ); ?></a>
				
				<?php
				do_action( 'yokoo_action_before_header' );

				// Header
				$yokoo_header_type = yokoo_get_theme_option( 'header_type' );
				if ( 'custom' == $yokoo_header_type && ! yokoo_is_layouts_available() ) {
					$yokoo_header_type = 'default';
				}
				get_template_part( apply_filters( 'yokoo_filter_get_template_part', "templates/header-" . sanitize_file_name( $yokoo_header_type ) ) );

				// Side menu
				if ( in_array( yokoo_get_theme_option( 'menu_side' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'yokoo_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				get_template_part( apply_filters( 'yokoo_filter_get_template_part', 'templates/header-navi-mobile' ) );

				do_action( 'yokoo_action_after_header' );

			}
			?>

			<div class="page_content_wrap"<?php
				if ( $yokoo_prev_post_loading ) {
					?> data-single-style="<?php echo esc_attr( yokoo_get_theme_option( 'single_style' ) ); ?>"<?php
				}
			?>>
				<?php
				do_action( 'yokoo_action_page_content_wrap', $yokoo_full_post_loading || $yokoo_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'yokoo_filter_single_post_header', is_singular( 'post' ) || is_singular( 'attachment' ) ) ) {
					if ( $yokoo_prev_post_loading ) {
						if ( yokoo_get_theme_option( 'posts_navigation_scroll_which_block' ) != 'article' ) {
							do_action( 'yokoo_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$yokoo_path = apply_filters( 'yokoo_filter_get_template_part', 'templates/single-styles/' . yokoo_get_theme_option( 'single_style' ) );
					if ( yokoo_get_file_dir( $yokoo_path . '.php' ) != '' ) {
						get_template_part( $yokoo_path );
					}
				}

				// Widgets area above page content
				$yokoo_body_style   = yokoo_get_theme_option( 'body_style' );
				$yokoo_widgets_name = yokoo_get_theme_option( 'widgets_above_page' );
				$yokoo_show_widgets = ! yokoo_is_off( $yokoo_widgets_name ) && is_active_sidebar( $yokoo_widgets_name );
				if ( $yokoo_show_widgets ) {
					if ( 'fullscreen' != $yokoo_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					yokoo_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $yokoo_body_style ) {
						?>
						</div><!-- </.content_wrap> -->
						<?php
					}
				}

				// Content area
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $yokoo_body_style ? '_fullscreen' : ''; ?>">

					<div class="content">
						<?php
						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="yokoo_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( is_singular( 'post' ) || is_singular( 'attachment' ) )
							&& $yokoo_prev_post_loading 
							&& yokoo_get_theme_option( 'posts_navigation_scroll_which_block' ) == 'article'
						) {
							do_action( 'yokoo_action_between_posts' );
						}

						// Widgets area inside page content
						yokoo_create_widgets_area( 'widgets_above_content' );
