<div class="front_page_section front_page_section_woocommerce<?php
	$yokoo_scheme = yokoo_get_theme_option( 'front_page_woocommerce_scheme' );
	if ( ! empty( $yokoo_scheme ) && ! yokoo_is_inherit( $yokoo_scheme ) ) {
		echo ' scheme_' . esc_attr( $yokoo_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( yokoo_get_theme_option( 'front_page_woocommerce_paddings' ) );
	if ( yokoo_get_theme_option( 'front_page_woocommerce_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$yokoo_css      = '';
		$yokoo_bg_image = yokoo_get_theme_option( 'front_page_woocommerce_bg_image' );
		if ( ! empty( $yokoo_bg_image ) ) {
			$yokoo_css .= 'background-image: url(' . esc_url( yokoo_get_attachment_url( $yokoo_bg_image ) ) . ');';
		}
		if ( ! empty( $yokoo_css ) ) {
			echo ' style="' . esc_attr( $yokoo_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$yokoo_anchor_icon = yokoo_get_theme_option( 'front_page_woocommerce_anchor_icon' );
	$yokoo_anchor_text = yokoo_get_theme_option( 'front_page_woocommerce_anchor_text' );
if ( ( ! empty( $yokoo_anchor_icon ) || ! empty( $yokoo_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_woocommerce"'
									. ( ! empty( $yokoo_anchor_icon ) ? ' icon="' . esc_attr( $yokoo_anchor_icon ) . '"' : '' )
									. ( ! empty( $yokoo_anchor_text ) ? ' title="' . esc_attr( $yokoo_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_woocommerce_inner
	<?php
	if ( yokoo_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
		echo ' yokoo-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$yokoo_css      = '';
			$yokoo_bg_mask  = yokoo_get_theme_option( 'front_page_woocommerce_bg_mask' );
			$yokoo_bg_color_type = yokoo_get_theme_option( 'front_page_woocommerce_bg_color_type' );
			if ( 'custom' == $yokoo_bg_color_type ) {
				$yokoo_bg_color = yokoo_get_theme_option( 'front_page_woocommerce_bg_color' );
			} elseif ( 'scheme_bg_color' == $yokoo_bg_color_type ) {
				$yokoo_bg_color = yokoo_get_scheme_color( 'bg_color', $yokoo_scheme );
			} else {
				$yokoo_bg_color = '';
			}
			if ( ! empty( $yokoo_bg_color ) && $yokoo_bg_mask > 0 ) {
				$yokoo_css .= 'background-color: ' . esc_attr(
					1 == $yokoo_bg_mask ? $yokoo_bg_color : yokoo_hex2rgba( $yokoo_bg_color, $yokoo_bg_mask )
				) . ';';
			}
			if ( ! empty( $yokoo_css ) ) {
				echo ' style="' . esc_attr( $yokoo_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
			<?php
			// Content wrap with title and description
			$yokoo_caption     = yokoo_get_theme_option( 'front_page_woocommerce_caption' );
			$yokoo_description = yokoo_get_theme_option( 'front_page_woocommerce_description' );
			if ( ! empty( $yokoo_caption ) || ! empty( $yokoo_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				// Caption
				if ( ! empty( $yokoo_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $yokoo_caption ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( $yokoo_caption, 'yokoo_kses_content' );
					?>
					</h2>
					<?php
				}

				// Description (text)
				if ( ! empty( $yokoo_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $yokoo_description ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( wpautop( $yokoo_description ), 'yokoo_kses_content' );
					?>
					</div>
					<?php
				}
			}

			// Content (widgets)
			?>
			<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
				<?php
				$yokoo_woocommerce_sc = yokoo_get_theme_option( 'front_page_woocommerce_products' );
				if ( 'products' == $yokoo_woocommerce_sc ) {
					$yokoo_woocommerce_sc_ids      = yokoo_get_theme_option( 'front_page_woocommerce_products_per_page' );
					$yokoo_woocommerce_sc_per_page = count( explode( ',', $yokoo_woocommerce_sc_ids ) );
				} else {
					$yokoo_woocommerce_sc_per_page = max( 1, (int) yokoo_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
				}
				$yokoo_woocommerce_sc_columns = max( 1, min( $yokoo_woocommerce_sc_per_page, (int) yokoo_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
				echo do_shortcode(
					"[{$yokoo_woocommerce_sc}"
									. ( 'products' == $yokoo_woocommerce_sc
											? ' ids="' . esc_attr( $yokoo_woocommerce_sc_ids ) . '"'
											: '' )
									. ( 'product_category' == $yokoo_woocommerce_sc
											? ' category="' . esc_attr( yokoo_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
											: '' )
									. ( 'best_selling_products' != $yokoo_woocommerce_sc
											? ' orderby="' . esc_attr( yokoo_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
												. ' order="' . esc_attr( yokoo_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
											: '' )
									. ' per_page="' . esc_attr( $yokoo_woocommerce_sc_per_page ) . '"'
									. ' columns="' . esc_attr( $yokoo_woocommerce_sc_columns ) . '"'
					. ']'
				);
				?>
			</div>
		</div>
	</div>
</div>
