<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package YOKOO
 * @since YOKOO 1.0
 */

							// Widgets area inside page content
							yokoo_create_widgets_area( 'widgets_below_content' );
						
							?>
						</div><!-- /.content -->
						<?php

						// Show main sidebar
						get_sidebar();
						?>
					</div><!-- /.content_wrap -->
					<?php

					// Widgets area below page content and related posts below page content
					$yokoo_body_style = yokoo_get_theme_option( 'body_style' );
					$yokoo_widgets_name = yokoo_get_theme_option( 'widgets_below_page' );
					$yokoo_show_widgets = ! yokoo_is_off( $yokoo_widgets_name ) && is_active_sidebar( $yokoo_widgets_name );
					$yokoo_show_related = is_single() && yokoo_get_theme_option( 'related_position' ) == 'below_page';
					if ( $yokoo_show_widgets || $yokoo_show_related ) {
						if ( 'fullscreen' != $yokoo_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $yokoo_show_related ) {
							do_action( 'yokoo_action_related_posts' );
						}

						// Widgets area below page content
						if ( $yokoo_show_widgets ) {
							yokoo_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $yokoo_body_style ) {
							?>
							</div><!-- /.content_wrap -->
							<?php
						}
					}
					?>
			</div><!-- /.page_content_wrap -->
			<?php

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! is_singular( 'post' ) && ! is_singular( 'attachment' ) ) || ! in_array ( yokoo_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="yokoo_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'yokoo_action_before_footer' );

				// Footer
				$yokoo_footer_type = yokoo_get_theme_option( 'footer_type' );
				if ( 'custom' == $yokoo_footer_type && ! yokoo_is_layouts_available() ) {
					$yokoo_footer_type = 'default';
				}
				get_template_part( apply_filters( 'yokoo_filter_get_template_part', "templates/footer-" . sanitize_file_name( $yokoo_footer_type ) ) );

				do_action( 'yokoo_action_after_footer' );

			}
			?>

		</div><!-- /.page_wrap -->

	</div><!-- /.body_wrap -->

	<?php wp_footer(); ?>

</body>
</html>